/*
 * Decompiled with CFR 0.152.
 */
package net.jayjay.dangerzone.client;

import java.awt.Canvas;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Random;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import net.jayjay.dangerzone.block.Block;
import net.jayjay.dangerzone.block.Blocks;
import net.jayjay.dangerzone.container.ContainerInventory;
import net.jayjay.dangerzone.entity.Entity;
import net.jayjay.dangerzone.entity.EntityBigPharma;
import net.jayjay.dangerzone.entity.EntityBlock;
import net.jayjay.dangerzone.entity.EntityBloodMonster;
import net.jayjay.dangerzone.entity.EntityButterfly;
import net.jayjay.dangerzone.entity.EntityDynamite;
import net.jayjay.dangerzone.entity.EntityHeadless;
import net.jayjay.dangerzone.entity.EntityItem;
import net.jayjay.dangerzone.entity.EntityLibtard;
import net.jayjay.dangerzone.entity.EntityPlayer;
import net.jayjay.dangerzone.entity.EntityTactikalTemplar;
import net.jayjay.dangerzone.entity.EntityTheCreator;
import net.jayjay.dangerzone.entity.EntityZombie;
import net.jayjay.dangerzone.gui.Gui;
import net.jayjay.dangerzone.gui.GuiIngame;
import net.jayjay.dangerzone.item.Item;
import net.jayjay.dangerzone.item.Items;
import net.jayjay.dangerzone.mods.ModLoader;
import net.jayjay.dangerzone.particle.ParticleEngine;
import net.jayjay.dangerzone.phys.HitResult;
import net.jayjay.dangerzone.player.Gamemode;
import net.jayjay.dangerzone.sound.Sound;
import net.jayjay.dangerzone.sound.SoundSystem;
import net.jayjay.dangerzone.src.Screenshot;
import net.jayjay.dangerzone.world.Frustum;
import net.jayjay.dangerzone.world.Timer;
import net.jayjay.dangerzone.world.World;
import net.jayjay.dangerzone.world.WorldRenderer;
import net.jayjay.dangerzone.world.chunk.Chunk;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;

public class DZ2
implements Runnable {
    public static String version = "Infdev 20260101";
    public static String titleName = "DZ2 " + version;
    public int width;
    public int height;
    public int levelX;
    public int levelY;
    public int levelZ;
    private FloatBuffer fogColor0 = BufferUtils.createFloatBuffer(4);
    private FloatBuffer fogColor1 = BufferUtils.createFloatBuffer(4);
    public Timer timer = new Timer(20.0f);
    public World world = null;
    private HitResult hitResult = null;
    public EntityPlayer thePlayer = null;
    public WorldRenderer worldRenderer = null;
    public ParticleEngine particleEngine = null;
    public int blockPaintTexture = 1;
    public int itemPaintTexture = 1;
    public int blockPaintLimit;
    public int itemPaintLimit;
    private IntBuffer viewportBuffer = BufferUtils.createIntBuffer(16);
    private IntBuffer selectBuffer = BufferUtils.createIntBuffer(2000);
    private FloatBuffer lb = BufferUtils.createFloatBuffer(16);
    public SoundSystem soundSystem;
    public static DZ2 theDangerZone;
    public static Random random;
    public static Gui theGui;
    public String titletext = "";
    public int fps = 0;
    public Canvas canvas;
    private JFrame frame;
    private boolean isFullscreen = false;
    public boolean isDebugMenu = false;
    public int entityCount = 0;
    int worldtick = 0;
    private float targetFov = 70.0f;
    private float currentFov = 70.0f;
    public ContainerInventory ci;

    public DZ2() {
        random = new Random();
        theDangerZone = this;
        this.canvas = new Canvas();
        this.canvas.setPreferredSize(new Dimension(1280, 720));
        this.canvas.setFocusable(true);
        this.canvas.setIgnoreRepaint(true);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            System.out.println("Stopping!");
            try {
                this.destroy();
            }
            catch (Exception e2) {
                System.err.println("Shutdown error :" + e2.getMessage());
            }
        }, "ShutdownHook"));
    }

    public void init() throws LWJGLException, IOException {
        this.soundSystem = new SoundSystem();
        ModLoader.addManually("net.jayjay.dangerzone.src.DZ2Base");
        try {
            ModLoader.loadMods();
        }
        catch (Exception e2) {
            System.err.println("Failed to load mods: " + e2.getMessage());
            e2.printStackTrace();
        }
        ModLoader.runInits();
        this.itemPaintLimit = Items.itemLimit = Items.nextId - 1;
        this.blockPaintLimit = Blocks.blockLimit = Blocks.nextId - 1;
        float fr = 0.5f;
        float fg = 0.8f;
        float fb = 1.0f;
        int col0 = 16710650;
        int col1 = 920330;
        this.fogColor0.put(new float[]{(float)(col0 >> 16 & 0xFF) / 255.0f, (float)(col0 >> 8 & 0xFF) / 255.0f, (float)(col0 & 0xFF) / 255.0f, 1.0f});
        this.fogColor0.flip();
        this.fogColor1.put(new float[]{(float)(col1 >> 16 & 0xFF) / 255.0f, (float)(col1 >> 8 & 0xFF) / 255.0f, (float)(col1 & 0xFF) / 255.0f, 1.0f});
        this.fogColor1.flip();
        Display.setParent(this.canvas);
        Display.setDisplayMode(new DisplayMode(1280, 720));
        Display.setTitle(String.valueOf(titleName) + " : " + this.titletext);
        Display.setResizable(true);
        Display.create();
        Keyboard.create();
        Mouse.create();
        this.updateViewport();
        GL11.glEnable(3553);
        GL11.glShadeModel(7425);
        GL11.glClearColor(fr, fg, fb, 0.0f);
        GL11.glClearDepth(1.0);
        GL11.glEnable(2929);
        GL11.glDepthFunc(515);
        GL11.glEnable(3008);
        GL11.glAlphaFunc(516, 0.1f);
        GL11.glMatrixMode(5889);
        GL11.glLoadIdentity();
        GL11.glMatrixMode(5888);
        theGui = new GuiIngame();
        this.ci = new ContainerInventory(new Object[]{Blocks.getBlockID("dz2:stone"), Blocks.getBlockID("dz2:grass"), 23, 4, 5, 6, 7, 8, 9}, 9);
        this.levelX = 512;
        this.levelY = 128;
        this.levelZ = 512;
        this.world = new World("level");
        this.worldRenderer = new WorldRenderer(this.world);
        this.thePlayer = new EntityPlayer(this.world);
        this.particleEngine = new ParticleEngine(this.world);
        Sound.playDZ2Sound("spawn");
        Mouse.setGrabbed(true);
    }

    public static void loadSound(String tag, String path) {
        if (DZ2.theDangerZone.soundSystem != null) {
            DZ2.theDangerZone.soundSystem.loadSound(tag, path);
        }
    }

    public void updateViewport() {
        this.width = Display.getWidth();
        this.height = Display.getHeight();
        GL11.glViewport(0, 0, this.width, this.height);
    }

    public void destroy() {
        this.world.shutdown();
        Mouse.destroy();
        Keyboard.destroy();
        this.soundSystem.destroy();
        Display.destroy();
        if (this.frame != null) {
            this.frame.dispose();
        }
    }

    @Override
    public void run() {
        System.out.println("Starting " + titleName);
        try {
            this.init();
        }
        catch (Exception var9) {
            JOptionPane.showMessageDialog(null, var9.toString(), "Failed to start " + titleName, 0);
            var9.printStackTrace();
            System.exit(0);
        }
        long lastTime = System.currentTimeMillis();
        int frames = 0;
        while (!Keyboard.isKeyDown(1) && !Display.isCloseRequested()) {
            long frameStart = System.nanoTime();
            this.timer.advanceTime();
            if (Display.wasResized()) {
                this.updateViewport();
            }
            long tickStart = System.nanoTime();
            int e2 = 0;
            while (e2 < this.timer.ticks) {
                this.tick();
                ++e2;
            }
            long tickTime = System.nanoTime() - tickStart;
            long renderStart = System.nanoTime();
            this.render(this.timer.a);
            long renderTime = System.nanoTime() - renderStart;
            ++frames;
            while (System.currentTimeMillis() >= lastTime + 1000L) {
                this.fps = frames;
                System.out.println(String.valueOf(frames) + " FPS (avg), " + String.format("%.2f", Float.valueOf(this.timer.fps)) + " FPS (instant), " + "Tick time: " + (double)tickTime / 1000000.0 + " ms, " + "Render time: " + (double)renderTime / 1000000.0 + " ms, " + Chunk.updates + " CHUNK UPDATES, " + Chunk.totalUpdates + " TOTAL CHUNK UPDATES, " + (double)Chunk.totalTime / 1000000.0 + " ms TOTAL CHUNK UPDATE TIME");
                Chunk.updates = 0;
                lastTime += 1000L;
                frames = 0;
                this.entityCount = this.world.entities.size();
            }
        }
        this.destroy();
    }

    public void tick() {
        float f2 = this.targetFov = Keyboard.isKeyDown(46) ? 30.0f : 70.0f;
        if (Math.abs(this.currentFov - this.targetFov) > 0.05f) {
            float speed = 1.0f - (float)Math.pow(1.0E-9, 0.01);
            this.currentFov += (this.targetFov - this.currentFov) * speed;
        } else {
            this.currentFov = this.targetFov;
        }
        this.thePlayer.fov = this.currentFov;
        while (Keyboard.next()) {
            if (!Keyboard.getEventKeyState()) continue;
            if (Keyboard.getEventKey() == 28) {
                this.saveGame();
            }
            if (Keyboard.getEventKey() == 60) {
                Screenshot.screenshot();
            }
            if (Keyboard.getEventKey() == 67) {
                Mouse.setGrabbed(false);
            }
            if (Keyboard.getEventKey() == 68) {
                Mouse.setGrabbed(true);
            }
            if (Keyboard.getEventKey() == 2) {
                Gamemode.setGamemode("dz2:survival_mode");
            }
            if (Keyboard.getEventKey() == 3) {
                Gamemode.setGamemode("dz2:creative_mode");
            }
            if (Keyboard.getEventKey() == 4) {
                Gamemode.setGamemode("dz2:ghost_mode");
            }
            if (Keyboard.getEventKey() == 16) {
                this.world.entities.add(new EntityBlock(this.world, this.thePlayer.x, this.thePlayer.y + 5.0f, this.thePlayer.z, Blocks.getBlockById(this.blockPaintTexture)));
            }
            if (Keyboard.getEventKey() == 37) {
                this.world.entities.add(new EntityItem(this.world, this.thePlayer.x, this.thePlayer.y + 5.0f, this.thePlayer.z, Items.getItemById(this.itemPaintTexture)));
            }
            if (Keyboard.getEventKey() == 34) {
                this.world.entities.add(new EntityZombie(this.world, this.thePlayer.x, this.thePlayer.y, this.thePlayer.z));
                Sound.playDZ2Sound("spawn");
            }
            if (Keyboard.getEventKey() == 48) {
                this.world.entities.add(new EntityBloodMonster(this.world, this.thePlayer.x, this.thePlayer.y, this.thePlayer.z));
                Sound.playDZ2Sound("spawn");
            }
            if (Keyboard.getEventKey() == 49) {
                this.world.entities.add(new EntityButterfly(this.world, this.thePlayer.x, this.thePlayer.y + 5.0f, this.thePlayer.z));
                Sound.playDZ2Sound("spawn");
            }
            if (Keyboard.getEventKey() == 25) {
                System.err.println("Bad idea! Spawning another player in the world could cause some issues.");
                this.world.entities.add(new EntityPlayer(this.world));
                Sound.playDZ2Sound("spawn");
            }
            if (Keyboard.getEventKey() == 35) {
                this.world.entities.add(new EntityHeadless(this.world, this.thePlayer.x, this.thePlayer.y, this.thePlayer.z));
                Sound.playDZ2Sound("spawn");
            }
            if (Keyboard.getEventKey() == 38) {
                this.world.entities.add(new EntityTheCreator(this.world, this.thePlayer.x, this.thePlayer.y, this.thePlayer.z));
                Sound.playDZ2Sound("spawn");
            }
            if (Keyboard.getEventKey() == 5) {
                this.world.entities.add(new EntityLibtard(this.world, this.thePlayer.x, this.thePlayer.y, this.thePlayer.z));
                Sound.playDZ2Sound("spawn");
            }
            if (Keyboard.getEventKey() == 6) {
                this.world.entities.add(new EntityBigPharma(this.world, this.thePlayer.x, this.thePlayer.y, this.thePlayer.z));
                Sound.playDZ2Sound("spawn");
            }
            if (Keyboard.getEventKey() == 7) {
                this.world.entities.add(new EntityTactikalTemplar(this.world, this.thePlayer.x, this.thePlayer.y, this.thePlayer.z));
                Sound.playDZ2Sound("spawn");
            }
            if (Keyboard.getEventKey() == 8) {
                this.world.entities.add(new EntityDynamite(this.world, this.thePlayer.x, this.thePlayer.y + 20.0f, this.thePlayer.z, 10.0f));
                Sound.playDZ2Sound("spawn");
            }
            if (Keyboard.getEventKey() == 44) {
                this.thePlayer.damageEntity(25);
            }
            if (Keyboard.getEventKey() == 61) {
                this.toggleF3DebugMenu();
            }
            if (Keyboard.getEventKey() == 11) {
                this.world.entities.clear();
            }
            if (Keyboard.getEventKey() == 87) {
                try {
                    this.toggleFullscreen();
                }
                catch (LWJGLException e2) {
                    e2.printStackTrace();
                }
            }
            if (Keyboard.getEventKey() == 51) {
                this.world.setRenderDistance(this.world.getRenderDistance() - 1);
            }
            this.handleBlockSwitchingKeyboard();
            this.handleItemSwitchingKeyboard();
        }
        ++this.worldtick;
        int tickbeforeupdate = 20;
        if (this.worldtick > 20) {
            // empty if block
        }
        this.particleEngine.tick();
        Frustum frustum = Frustum.getFrustum();
        int i2 = 0;
        while (i2 < this.world.entities.size()) {
            Entity entity = this.world.entities.get(i2);
            entity.tick();
            if (entity.removed) {
                this.world.entities.remove(i2--);
            }
            ++i2;
        }
        this.thePlayer.tick();
        ModLoader.tickMods();
    }

    private void moveCameraToPlayer(float a2) {
        GL11.glTranslatef(0.0f, 0.0f, -0.3f);
        GL11.glRotatef(this.thePlayer.xRot, 1.0f, 0.0f, 0.0f);
        GL11.glRotatef(this.thePlayer.yRot, 0.0f, 1.0f, 0.0f);
        float x = this.thePlayer.xo + (this.thePlayer.x - this.thePlayer.xo) * a2;
        float y = this.thePlayer.yo + (this.thePlayer.y - this.thePlayer.yo) * a2;
        float z = this.thePlayer.zo + (this.thePlayer.z - this.thePlayer.zo) * a2;
        GL11.glTranslatef(-x, -y, -z);
    }

    private void setupCamera(float a2) {
        GL11.glMatrixMode(5889);
        GL11.glLoadIdentity();
        GLU.gluPerspective(this.thePlayer.fov, (float)this.width / (float)this.height, 0.05f, 1000.0f);
        GL11.glMatrixMode(5888);
        GL11.glLoadIdentity();
        this.moveCameraToPlayer(a2);
    }

    private void setupPickCamera(float a2, int x, int y) {
        GL11.glMatrixMode(5889);
        GL11.glLoadIdentity();
        this.viewportBuffer.clear();
        GL11.glGetInteger(2978, this.viewportBuffer);
        this.viewportBuffer.flip();
        this.viewportBuffer.limit(16);
        GLU.gluPickMatrix(x, y, 5.0f, 5.0f, this.viewportBuffer);
        GLU.gluPerspective(this.thePlayer.fov, (float)this.width / (float)this.height, 0.05f, 1000.0f);
        GL11.glMatrixMode(5888);
        GL11.glLoadIdentity();
        this.moveCameraToPlayer(a2);
    }

    private void pick(float a2) {
        this.selectBuffer.clear();
        GL11.glSelectBuffer(this.selectBuffer);
        GL11.glRenderMode(7170);
        this.setupPickCamera(a2, this.width / 2, this.height / 2);
        this.worldRenderer.pick(this.thePlayer, Frustum.getFrustum());
        int hits = GL11.glRenderMode(7168);
        this.selectBuffer.flip();
        this.selectBuffer.limit(this.selectBuffer.capacity());
        long closest = 0L;
        int[] names = new int[10];
        int hitNameCount = 0;
        int i2 = 0;
        while (i2 < hits) {
            int j;
            int nameCount = this.selectBuffer.get();
            long minZ = this.selectBuffer.get();
            this.selectBuffer.get();
            if (minZ >= closest && i2 != 0) {
                j = 0;
                while (j < nameCount) {
                    this.selectBuffer.get();
                    ++j;
                }
            } else {
                closest = minZ;
                hitNameCount = nameCount;
                j = 0;
                while (j < nameCount) {
                    names[j] = this.selectBuffer.get();
                    ++j;
                }
            }
            ++i2;
        }
        this.hitResult = hitNameCount > 0 ? new HitResult(names[0], names[1], names[2], names[3], names[4]) : null;
    }

    public void render(float a2) {
        float xo = Mouse.getDX();
        float yo = Mouse.getDY();
        this.thePlayer.turn(xo, yo);
        this.pick(a2);
        while (Mouse.next()) {
            if (Mouse.getEventButton() == 0 && Mouse.getEventButtonState() && this.hitResult != null) {
                Block block = Blocks.getBlockById(this.world.getBlock(this.hitResult.x, this.hitResult.y, this.hitResult.z));
                boolean destroy = this.world.setBlock(this.hitResult.x, this.hitResult.y, this.hitResult.z, 0);
                Block blockAbove = Blocks.getBlockById(this.world.getBlock(this.hitResult.x, this.hitResult.y + 1, this.hitResult.z));
                if (block != null && destroy) {
                    boolean success;
                    if (block.getBlockSounds(block.blockTag).equals("dz2:breakGround")) {
                        Sound.playDZ2Sound("breakGround");
                    } else if (block.getBlockSounds(block.blockTag).equals("dz2:shatter")) {
                        Sound.playDZ2Sound("shatter");
                    } else {
                        Sound.playDZ2Sound("breakBlock");
                    }
                    block.destroy(this.world, this.hitResult.x, this.hitResult.y, this.hitResult.z, this.particleEngine);
                    if (blockAbove.isPlant() && !this.world.isEntityInBlock(this.hitResult.x, this.hitResult.y + 1, this.hitResult.z) && (success = this.world.setBlock(this.hitResult.x, this.hitResult.y + 1, this.hitResult.z, 0))) {
                        blockAbove.destroy(this.world, this.hitResult.x, this.hitResult.y + 1, this.hitResult.z, this.particleEngine);
                        if (block.getBlockSounds(block.blockTag).equals("dz2:shatter")) {
                            Sound.playDZ2Sound("shatter");
                        }
                    }
                }
            }
            if (Mouse.getEventButton() == 1 && Mouse.getEventButtonState()) {
                Item selectedItem = Items.getItemById(this.itemPaintTexture);
                if (selectedItem != null && selectedItem.isUseable()) {
                    selectedItem.onUse(this.thePlayer);
                } else if (this.hitResult != null) {
                    int hrx = this.hitResult.x;
                    int hry = this.hitResult.y;
                    int hrz = this.hitResult.z;
                    if (this.hitResult.f == 0) {
                        --hry;
                    }
                    if (this.hitResult.f == 1) {
                        ++hry;
                    }
                    if (this.hitResult.f == 2) {
                        --hrz;
                    }
                    if (this.hitResult.f == 3) {
                        ++hrz;
                    }
                    if (this.hitResult.f == 4) {
                        --hrx;
                    }
                    if (this.hitResult.f == 5) {
                        ++hrx;
                    }
                    this.world.setBlock(hrx, hry, hrz, this.blockPaintTexture);
                    Sound.playDZ2Sound("placeBlock");
                }
            }
            this.handleBlockSwitching();
        }
        GL11.glClear(16640);
        this.setupCamera(a2);
        GL11.glEnable(2884);
        Frustum frustum = Frustum.getFrustum();
        ++this.worldtick;
        int tickbeforeupdate = 20;
        if (this.worldtick > 20) {
            this.world.updateLoadedChunks(this.thePlayer.x, this.thePlayer.z);
        }
        if (this.worldtick > 20) {
            this.worldRenderer.updateDirtyChunks(this.thePlayer);
            this.worldtick = 0;
        }
        this.setupFog(0);
        GL11.glEnable(2912);
        this.worldRenderer.render(this.thePlayer, 0);
        for (Entity entity : this.world.entities) {
            if (!entity.isLit() || !frustum.isVisible(entity.bb)) continue;
            entity.render(a2);
        }
        this.particleEngine.render(this.thePlayer, a2, 0);
        this.setupFog(1);
        this.worldRenderer.render(this.thePlayer, 1);
        for (Entity entity : this.world.entities) {
            if (entity.isLit() || !frustum.isVisible(entity.bb)) continue;
            entity.render(a2);
        }
        this.particleEngine.render(this.thePlayer, a2, 1);
        GL11.glDisable(2896);
        GL11.glDisable(3553);
        GL11.glDisable(2912);
        if (this.hitResult != null) {
            GL11.glDisable(3008);
            this.worldRenderer.renderHit(this.hitResult);
            GL11.glEnable(3008);
        }
        theGui.drawGui(a2);
        Display.update();
    }

    private void setupFog(int fogMode) {
        if (fogMode == 0) {
            GL11.glFogi(2917, 2048);
            GL11.glFogf(2914, 0.001f);
            GL11.glFog(2918, this.fogColor0);
            GL11.glDisable(2896);
        } else if (fogMode == 1) {
            GL11.glFogi(2917, 2048);
            GL11.glFogf(2914, 0.06f);
            GL11.glFog(2918, this.fogColor1);
            GL11.glEnable(2896);
            GL11.glEnable(2903);
            float brightness = 0.6f;
            GL11.glLightModel(2899, this.getBuffer(brightness, brightness, brightness, 1.0f));
        }
    }

    private FloatBuffer getBuffer(float a2, float b2, float c2, float d2) {
        this.lb.clear();
        this.lb.put(a2).put(b2).put(c2).put(d2);
        this.lb.flip();
        return this.lb;
    }

    public void randomTitleText() {
        try {
            ArrayList<String> var1 = new ArrayList<String>();
            BufferedReader var2 = new BufferedReader(new InputStreamReader(DZ2.class.getResourceAsStream("/titletext.txt"), Charset.forName("UTF-8")));
            String var3 = "";
            while (true) {
                if ((var3 = var2.readLine()) == null) {
                    this.titletext = (String)var1.get(random.nextInt(var1.size()));
                    break;
                }
                if ((var3 = var3.trim()).length() <= 0) continue;
                var1.add(var3);
            }
        }
        catch (Exception var4) {
            var4.printStackTrace();
        }
    }

    public void handleBlockSwitching() {
        int dWheel = Mouse.getDWheel();
        if (dWheel != 0) {
            if (dWheel < 0) {
                Sound.playDZ2Sound("switchTab");
                DZ2.theDangerZone.blockPaintTexture = DZ2.theDangerZone.blockPaintTexture < DZ2.theDangerZone.blockPaintLimit ? ++DZ2.theDangerZone.blockPaintTexture : 1;
                if (Keyboard.isKeyDown(56)) {
                    this.thePlayer.fov += 1.0f;
                }
            } else {
                Sound.playDZ2Sound("switchTab");
                DZ2.theDangerZone.blockPaintTexture = DZ2.theDangerZone.blockPaintTexture > 1 ? --DZ2.theDangerZone.blockPaintTexture : DZ2.theDangerZone.blockPaintLimit;
                if (Keyboard.isKeyDown(56)) {
                    this.thePlayer.fov -= 1.0f;
                }
            }
        }
    }

    public void handleBlockSwitchingKeyboard() {
        if (Keyboard.getEventKey() == 205) {
            Sound.playDZ2Sound("switchTab");
            this.blockPaintTexture = this.blockPaintTexture < this.blockPaintLimit ? ++this.blockPaintTexture : 1;
        }
        if (Keyboard.getEventKey() == 203) {
            Sound.playDZ2Sound("switchTab");
            this.blockPaintTexture = this.blockPaintTexture > 1 ? --this.blockPaintTexture : this.blockPaintLimit;
        }
    }

    public void handleItemSwitchingKeyboard() {
        if (Keyboard.getEventKey() == 200) {
            Sound.playDZ2Sound("switchTab");
            this.itemPaintTexture = this.itemPaintTexture < this.itemPaintLimit ? ++this.itemPaintTexture : 1;
        }
        if (Keyboard.getEventKey() == 208) {
            Sound.playDZ2Sound("switchTab");
            this.itemPaintTexture = this.itemPaintTexture > 1 ? --this.itemPaintTexture : this.itemPaintLimit;
        }
    }

    private void toggleFullscreen() throws LWJGLException {
        this.isFullscreen = !this.isFullscreen;
        try {
            if (this.isFullscreen) {
                DisplayMode bestMode = Display.getDesktopDisplayMode();
                Display.setDisplayModeAndFullscreen(bestMode);
                this.frame.setVisible(false);
                this.canvas.setSize(bestMode.getWidth(), bestMode.getHeight());
            } else {
                Display.setDisplayMode(new DisplayMode(1280, 720));
                Display.setFullscreen(false);
                this.frame.setVisible(true);
                this.canvas.setSize(1280, 720);
                this.frame.pack();
                this.frame.setLocationRelativeTo(null);
            }
            this.updateViewport();
            GL11.glEnable(3553);
            GL11.glShadeModel(7425);
            GL11.glClearDepth(1.0);
            GL11.glEnable(2929);
            GL11.glDepthFunc(515);
            GL11.glEnable(3008);
            GL11.glAlphaFunc(516, 0.5f);
            GL11.glMatrixMode(5889);
            GL11.glLoadIdentity();
            GL11.glMatrixMode(5888);
            Mouse.setGrabbed(true);
        }
        catch (LWJGLException e2) {
            this.isFullscreen = !this.isFullscreen;
            System.err.println("Failed to toggle fullscreen: " + e2.getMessage());
            throw e2;
        }
    }

    private void toggleF3DebugMenu() {
        this.isDebugMenu = !this.isDebugMenu;
    }

    public void saveGame() {
        this.world.save();
    }

    public static DZ2 getInstance() {
        return theDangerZone;
    }

    public static void main(String[] args) {
        try {
            DZ2 game = new DZ2();
            game.randomTitleText();
            game.frame = new JFrame(String.valueOf(titleName) + " : " + game.titletext);
            game.frame.setDefaultCloseOperation(3);
            game.frame.add(game.canvas);
            game.frame.pack();
            game.frame.setLocationRelativeTo(null);
            game.frame.setVisible(true);
            new Thread(game).start();
        }
        catch (Exception e2) {
            e2.printStackTrace();
            System.exit(1);
        }
    }
}

